unit RandUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls, ExtCtrls, Math;   // Math vanwege gebruik machten

type
  TRandForm = class(TForm)
    MainMenu1: TMainMenu;
    Bestand1: TMenuItem;
    Openen1: TMenuItem;
    Sluiten1: TMenuItem;
    Afsluiten1: TMenuItem;
    Help1: TMenuItem;
    Help2: TMenuItem;
    About1: TMenuItem;
    Debaanvaneenpunt1: TMenuItem;
    Toelichting1: TMenuItem;
    PaintBox: TPaintBox;
    invulPanel: TPanel;
    cLabel: TLabel;
    aLabel: TLabel;
    bLabel: TLabel;
    aEdit: TEdit;
    bEdit: TEdit;
    ResetABButton: TButton;
    abKeuzeComboBox: TComboBox;
    ComboboxLabel: TLabel;
    TekenButton: TButton;
    ResetButton: TButton;
    UitlegMemo: TMemo;
    Panel1: TPanel;
    ZoomLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    AantalLabel: TLabel;
    VergrotingLabel: TLabel;
    CoordLabel: TLabel;
    BreedteLabel: TLabel;
    HoogteLabel: TLabel;
    procedure Debaanvaneenpunt1Click(Sender: TObject); // Menu-item
    procedure Toelichting1Click(Sender: TObject); // Menu-item
    procedure Sluiten1Click(Sender: TObject);  // Menu-item
    procedure Afsluiten1Click(Sender: TObject); // Menu-item
    procedure Help2Click(Sender: TObject);   // Menu-item
    procedure About1Click(Sender: TObject); // Menu-item
    procedure PaintBoxPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure aEditKeyPress(Sender: TObject; var Key: Char);
    procedure bEditKeyPress(Sender: TObject; var Key: Char);
    procedure abKeuzeComboBoxSelect(Sender: TObject);
    procedure TekenButtonClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure ResetABButtonClick(Sender: TObject);
    procedure PaintBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    


  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RandForm: TRandForm;
  a,b,xmax,ymax, dx, dy, xcoord, ycoord : double;
  // xmax en ymax zijn (halve) breedte en hoogte van de Paintbox
  // dx en dy zijn stapgrootte voor x en y voor de pixels in de Paintbox
  hbreedte, hhoogte: double; // (variabele) halve breedte en hoogte voor x-  resp
                     //y-coordinaten voor ingezoomd venster
  factor: Integer; // zoomfactor
  muisPos: TPoint; // punt waar de muis is
  xcentr, ycentr: double; // coordinaten centrum inzoomvenster
  aantal: Integer; // telt aantal keer inzoomen
  vergroting: double;
  klikbaar: Boolean; //houdt bij of er in Paintbox geklikt mag worden om in te zoomen
implementation

uses Unit3, Unit2, Unit4, Unit1, BaanUnit;

{$R *.dfm}

procedure TRandForm.FormShow(Sender: TObject);
begin
     RandForm.Top:=openingForm.Top;
     RandForm.Left:=openingForm.Left;
     xmax := 2;
     ymax := 1.5;
     hbreedte := xmax;
     hhoogte := ymax;
     dx:= hbreedte/300;
     dy:= hhoogte/225;
     factor := 4;
     xcentr := 0;
     ycentr := 0;
     aantal := 0;
     klikbaar := false;
     aEdit.SetFocus;
end;

// Menu-item
procedure TRandForm.Debaanvaneenpunt1Click(Sender: TObject); 
begin
     RandForm.Close;
     BaanForm.Show;
end;

// Menu-item
procedure TRandForm.Toelichting1Click(Sender: TObject);  
begin
     RandForm.Close;
     ToelichtingForm.Show;
end;

// Menu-item
procedure TRandForm.Sluiten1Click(Sender: TObject);  
begin
     RandForm.Close;
end;

// Menu-item
procedure TRandForm.Afsluiten1Click(Sender: TObject);  
begin
     if MessageDlg('Weet U zeker dat U wilt afsluiten?',
        mtConfirmation, [mbYes, mbCancel],0)=mrYes then
        Application.Terminate;
end;

// Menu-item
procedure TRandForm.Help2Click(Sender: TObject);  
begin
     RandForm.Close;
     HelpForm.Show;
end;

// Menu-item
procedure TRandForm.About1Click(Sender: TObject); 
begin
     AboutBox.Show;
end;



function pixx (x: real) :integer; //zet x-coordinaat om in pixelcoord van PaintBox
begin                             //geldt alleen in beginsituatie!!
     result:=round(x*300/hbreedte +300);
end;

function invpixx(x: integer) : real;  //zet pixel-x-coordinaat om in x-coordinaat
begin                                 //geldt ook in ingezoomde vensters
     result := xcentr - hbreedte + x * hbreedte/300;
end;

function pixy (y: real) :integer; //zet y-coordinaat om in pixelcoord van PaintBox
begin                             //geldt alleen in beginsituatie!!
     result:=round((hhoogte-y)/hhoogte*225);
end;

function invpixy(y: integer): real;  // zet pixel-y-coordinaat om in y-coordinaat
begin                                //geldt ook in ingezoomde vensters
     result := ycentr + hhoogte - y*hhoogte/225;
end;

function funcx(x,y: real) :real; //berekent reele deel f(z)=z^2+c
begin
     result:=x*x-y*y+a;
end;

function funcy(x,y: real) :real; //berekent imaginaire deel f(z)=z^2+c
begin
     result:=2*x*y+b;
end;

function dist(x,y,p,q: real) :real; // berekent kwadraat vd afstand punt(x,y) tot (p,q)
begin
     result:=(x-p)*(x-p)+(y-q)*(y-q);
end;

procedure cirkelTekenen;
var
   i: integer;
begin
     with RandForm.PaintBox.Canvas do
     begin
          MoveTo(pixx(-1),pixy(0));
          Pen.Color:=clYellow;
          for i:=-150 to 150 do   //bovenste helft
              begin
                   x:=i/150;
                   y:=sqrt(1-x*x);
                   LineTo(pixx(x),pixy(y));
              end;
          MoveTo(pixx(-1),pixy(0));
          for i:=-150 to 150 do   //onderste helft
              begin
                   x:=i/150;
                   y:=-sqrt(1-x*x);
                   LineTo(pixx(x),pixy(y));
              end;
     end;
end;



procedure TRandForm.PaintBoxPaint(Sender: TObject);
var
   i :integer;
begin
      with PaintBox.Canvas do
     begin
          Pen.Color:= clBlack; //rand tekenen
          MoveTo(0, 0);
          LineTo(0, 450);
          LineTo(600, 450);
          LineTo(600, 0);
          LineTo(0, 0);
          Pen.Color:=clBlue; //assen tekenen
          MoveTo(0, 225);
          LineTo(600, 225);
          MoveTo(300, 0);
          LineTo(300, 450);
          Pen.Color:=clGreen; //maatstrepen assenverdeling
          for i:=0 to 7 do //horizontaal
              begin
                  MoveTo(0+75*i,228);
                  LineTo(0+75*i,222);
              end;
          for i:=0 to 5 do //vertikaal
              begin
                  MoveTo(303,0+75*i);
                  LineTo(297,0+75*i);
              end;
          //schaalverdeling vermelden
          TextOut(5, 230, FloatToStr(-xmax)); //hor as
          TextOut(140, 228, FloatToStr(-xmax/2));
          TextOut(445, 228, FloatToStr(xmax/2));  
          TextOut(585, 228, FloatToStr(xmax));
          TextOut(282, 10, FloatToStr(ymax)); // vert as
          TextOut(280, 435, FloatToStr(-ymax));
     end;
     cirkelTekenen;
end;




procedure TRandForm.aEditKeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then  //#13 = ENTER-toets
        begin
             bEdit.SetFocus;
             try
                a:=StrToFloat(aEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Kies a tussen -2 en 2!');
                        aEdit.SetFocus;
                   end;
             end;
        if (a<-2) or (a>2) then
           begin
                ShowMessage('Kies a tussen -2 en 2!');
                aEdit.SetFocus;
           end;
        abKeuzeCombobox.ItemIndex:=0; // geen item geslecteerd, 'Kies' getoond
        end;
end;



procedure TRandForm.bEditKeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then
        begin
             TekenButton.SetFocus;
             try
                b:=StrToFloat(bEdit.Text);
             except
                on EConvertError do
                   begin
                        ShowMessage('Kies b tussen -2 en 2!');
                        bEdit.SetFocus;
                   end;
             end;
        if (b<-2) or (b>2) then
           begin
                ShowMessage('Kies b tussen -2 en 2!');
                bEdit.Text:='';
                bEdit.SetFocus;
           end;
        abKeuzeCombobox.ItemIndex:=0; // geen item geslecteerd, 'Kies' getoond
        end;
end;


procedure TRandForm.abKeuzeComboBoxSelect(Sender: TObject);
begin
   case abKeuzeCombobox.ItemIndex of
     1:  begin a:= -1.754878; b:=0; end;
     2:  begin a:= 0.36; b:=0.1; end;
     3:  begin a:= -1.25; b:=0; end;
     4:  begin a:= -1; b:=0; end;
     5:  begin a:= -0.75; b:=0; end;
     6:  begin a:= 0.25; b:=0; end;
     7:  begin a:= 0.365; b:=0.1; end;
     8:  begin a:= -0.122561; b:=0.744862; end;
     9:  begin a:= -0.8; b:=0.1; end;
     10: begin a:= -1.25; b:=0.01; end;
     11: begin a:= 0.25; b:=0.25; end;
     12: begin a:= -0.318472; b:=0.041257; end;
     13: begin a:= -0.95; b:=0.25; end;
     14: begin a:= 0.15; b:=0.6; end;
   end;
     aEdit.Text:=FloatToStr(a);
     bEdit.Text:=FloatToStr(b);
end;

procedure puntTekenen(x,y: real; kleur: TColor);
var
p,q: Integer;
begin
     p:=pixx(x); // reele coord omzetten in PaintBoxcoordinaten
     q:=pixY(y);
     RandForm.PaintBox.Canvas.Pixels[p, q]:=kleur;
end;


procedure TRandForm.TekenButtonClick(Sender: TObject);
// hiermee wordt berekening gestart van de kleur voor elke pixel in Paintbox
var
   i,j,k,start: Integer;
   x,y,p,q: real;
   //x,y,p,q zijn variabelen voor de berekende coord vd punten in de baan
begin

   a:= StrToFloat(aEdit.Text);
   b:= StrToFloat(bEdit.Text);
   if (b=0) then start :=0 else start:= -299;
   for j:=224 downto 0 do  // rij voor rij
     begin
       for i:=start to 299 do  // elke x van een rij
         begin
            x := i*dx;
            y := j*dy;
            k := 0;
            repeat
                 p := funcx(x,y); //hulpvariabelen
                 q := funcy(x,y);
                 x := p;
                 y := q;
                 k:=k+1;
             until ((k>300) or ((x>100000) or (y>100000)));
                              // waarden veroorzaken anders overflow!!
                              
             p := funcx(x,y); //nog een rekenslag, anders zijn x,p en y,q gelijk!!
             q := funcy(x,y);
             if dist(x,y,p,q)<0.01 then
                begin
                     puntTekenen(i*dx,j*dy,clBlue);
                     puntTekenen(-i*dx,-j*dy,clBlue);
                     if (b=0) then
                        begin
                           puntTekenen(-i*dx,j*dy,clBlue);
                           puntTekenen(i*dx,-j*dy,clBlue);
                        end;
                end;
              if dist(0,0,x,y)>1000 then
                begin
                     puntTekenen(i*dx,j*dy,clRed);
                     puntTekenen(-i*dx,-j*dy,clRed);
                     if (b=0) then
                        begin
                           puntTekenen(-i*dx,j*dy,clRed);
                           puntTekenen(i*dx,-j*dy,clRed);
                        end;
                end;
                if not((dist(x,y,p,q)<0.001) or (dist(0,0,x,y)>1000)) then
                    begin
                         puntTekenen(i*dx,j*dy,clYellow);
                         puntTekenen(-i*dx,-j*dy,clYellow);
                         if (b=0) then
                            begin
                                 puntTekenen(-i*dx,j*dy,clYellow);
                                 puntTekenen(i*dx,-j*dy,clYellow);
                            end;
                    end;
         end;
     end;
     ZoomLabel.Visible := true;
     klikbaar := true;
     ResetButton.SetFocus;
end;

procedure TRandForm.ResetButtonClick(Sender: TObject);
begin
     aEdit.Enabled := true;
     bEdit.Enabled := true;
     abKeuzeComboBox.Enabled := true;
     ResetABButton.Enabled := true;
     TekenButton.Enabled := true;
     hbreedte := xmax;
     hhoogte := ymax;
     xcentr := 0;
     ycentr := 0;
     dx := hbreedte/300;
     dy := hhoogte/225;
     aantal := 0;
     vergroting := 1;
     PaintBox.Repaint;
     ZoomLabel.Visible := false;
     RandForm.Panel1.visible:= false;
     klikbaar := false;
     aEdit.SetFocus;

end;

procedure TRandForm.ResetABButtonClick(Sender: TObject);
begin
     aEdit.SetFocus;
end;

procedure TRandForm.PaintBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
   i,j,k: Integer; // tellers
   u,v,p,q: real;  // (hulp-)coordinaten punt
begin
     if (klikbaar) then
     begin
          aEdit.Enabled := false;
          bEdit.Enabled := false;
          abKeuzeComboBox.Enabled := false;
          ResetABButton.Enabled := false;
          TekenButton.Enabled := false;
          muisPos:=Mouse.CursorPos; //muiscoordinaten op hele scherm
          muisPos:=PaintBox.ScreenToClient(muisPos);  //PaintBox(=client)-coordinaten
          xcentr:=invpixx(muisPos.x); //x-coordinaat
          ycentr:=invpixy(muisPos.y); //y-coordinaat
     
          hbreedte := hbreedte/factor; // nieuwe maten scherm
          hhoogte := hhoogte/factor;
          dx := hbreedte/300;
          dy := hhoogte/225;

          with PaintBox.Canvas do // rand venster tekenen
          begin
               PaintBox.Canvas.FillRect(PaintBox.Canvas.ClipRect); //scherm schoonmaken
               Pen.Color:= clBlack; //rand tekenen
               MoveTo(0, 0);
               LineTo(0, 450);
               LineTo(600, 450);
               LineTo(600, 0);
               LineTo(0, 0);
          end;
          aantal := aantal + 1;
          AantalLabel.Caption := IntToStr(aantal);
          vergroting := Power(factor, aantal);  // factor ^ aantal,  uit Math
          VergrotingLabel.Caption := FloatToStr(vergroting);
          CoordLabel.Caption := '(' +FloatToStr(xcentr) + ', ' +  FloatToStr(ycentr) + ')';
          BreedteLabel.Caption := FloatToStr(2*hbreedte);
          HoogteLabel.Caption := FloatToStr(2*hhoogte);
          RandForm.Panel1.Visible := true;

          // nu volgt berekening kleur van elk punt en tekenen
          for j:=-224 to 224 do // rij voor rij, van bovenaf
          begin
               for i:=-299 to 299 do // elke x in een rij
                   begin
                        u:=xcentr + i*dx;
                        v:=ycentr - j*dy; //tegengestelde waarde voor j nemen ivm 'op zijn
                                 //kop staande' venster van PaintBox
                        k:=0;
                        repeat
                              p := funcx(u,v); //hulpvariabelen
                              q := funcy(u,v);
                              u := p;
                              v := q;
                              k:=k+1;
                        until ((k>200) or ((u>10000) or (v>10000)));
                              // waarden veroorzaken anders overflow!!
                        p := funcx(u,v); //hulpvariabelen
                        q := funcy(u,v);
                        if dist(u,v,p,q)<0.001 then
                           RandForm.PaintBox.Canvas.Pixels[300+i,225+ j]:=clBlue;
                        if dist(0,0,u,v)>1000 then
                           RandForm.PaintBox.Canvas.Pixels[300+i,225 + j]:=clRed;
                        if not ((dist(u,v,p,q)<0.001) or (dist(0,0,u,v)>1000)) then
                           RandForm.PaintBox.Canvas.Pixels[300+i,225 + j]:=clYellow;
                   end;
               end;

          ResetButton.SetFocus;
     end;
end;


end.
